---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-Global Page

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00000.sql` (行1-38)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (行2)
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` (行109)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは0である | E-01（行15: p_id=>0） | ○ |
| C-02 | ページ名はGlobal Pageである | E-01（行16: p_name=>'Global Page'） | ○ |
| C-03 | Protection LevelはDである | E-01（行21: p_protection_level=>'D'） | ○ |
| C-04 | AutocompleteはOFFに設定されている | E-01（行18: p_autocomplete_on_off=>'OFF'） | ○ |
| C-05 | Provider SloganリージョンがREGION_POSITION_05に配置されている | E-01（行29: p_plug_display_point=>'REGION_POSITION_05'） | ○ |
| C-06 | リージョン名はProvider Sloganである | E-01（行25: p_plug_name=>'Provider Slogan'） | ○ |
| C-07 | 置換文字列&PROVIDER_SLOGAN.を使用している | E-01（行31: p_plug_source containing '&PROVIDER_SLOGAN.'） | ○ |
| C-08 | フォントサイズはCSS変数を使用している | E-01（行31: '--ut-footer-apex-font-size'を参照） | ○ |
| C-09 | 全ページ共通で使用される | E-02（説明欄: 「全ページで共通して使用」） | ○ |
| C-10 | フッターにプロバイダースローガンを表示 | E-02（説明欄）、E-01（行29-31） | ○ |
| C-11 | 出力形式はHTMLである | E-01（行34: 'output_as', 'HTML'） | ○ |
| C-12 | 画面種別はシステムページである | E-03（行109: タイプ「システム」） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] Provider Sloganの置換文字列がアプリケーション設定で定義されているか確認
- [ ] CSS変数「--ut-footer-apex-font-size」がUniversal Themeで定義されているか確認
- [ ] Protection Level「D」がアプリケーションのセキュリティ要件に適合しているか確認
